function [Xvec] = conversionscript(MF_tol,MF_chlbnz,MF_hex, Tvec)

U = 5e-6; % W/mm^2/K Overall Heat Trnsfr Coeff
A = 237; % mm^2 Surface area of reactor
delH = -266000; % J/mol Heat of rxn

cpToluene = 157.09; % J/mol/K, Heat cap of Toluene Grolier, Roux-Desgranges, et al., 1993
cpChlorobenz = 152.1; %J/mol/K, Heat cap of chlorobenzene Shehatta, 1993

total_HC = cpToluene * MF_tol + cpChlorobenz * MF_chlbnz;

for i = 2:length(Tvec)
    Xvec(i) = (total_HC.*(Tvec(i))+ U*A*(Tvec(i)-Tvec(i-1))) ./ (MF_hex*(-(delH)));
end

end